/**
 * Fecha de creacin: (17/11/2010)
 */   
package com.ejie.p06b.pdf.xml;

import javax.servlet.http.HttpServletRequest;
import com.ejie.p06b.datatype.logic.P06BInformeDEC;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.manager.P06BCorredoresManager;
import com.ejie.p06b.util.P06BUtil;
import java.text.DecimalFormat;

/**
 * Clase que representa el xml para el pdf
 */
public class P06BInformeResumenDECXML{
   
	public static String getXml(HttpServletRequest request)
	throws Exception {
		P06BLog.send(2,"P06BInformeResumenDECXML", "getXml(...): Inicio");
		
		DecimalFormat decimalFormat = new DecimalFormat("####.####");
		
		String ejerDEC = (request.getParameter("EjercicioResumenDEC")==null)?"":request.getParameter("EjercicioResumenDEC");
		
		//Hacer las SELECT a la base de datos, para calcular los campos, y cargar el objeto P06BInformeDEC con los datos calculados
		P06BInformeDEC objInformeDEC = P06BCorredoresManager.getInstance().selectInformeResumenDEC(ejerDEC);

		StringBuffer xml = new StringBuffer();
	
		xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
		xml.append("<informeDEC>");
			xml.append("<ejercicio>");
				xml.append(ejerDEC);
			xml.append("</ejercicio>");
			xml.append("<numMediadEnviadaDEC>");
				xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getNumMediadEnviadaDEC()),0));
			xml.append("</numMediadEnviadaDEC>");
			
			
			
			//-----------------------------------  MODELO 1 --------------------------------------
			//Mediadores F, J, RF y RJ
			xml.append("<corrM1>");
				xml.append("<numEmpCorrM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getNumEmpCorrM1()),0));
				xml.append("</numEmpCorrM1>");
				xml.append("<afecDirCorrM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getAfecDirCorrM1()),0));
				xml.append("</afecDirCorrM1>");
				xml.append("<noAfecDirCorrM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getNoAfecDirCorrM1()),0));
				xml.append("</noAfecDirCorrM1>");
				xml.append("<afecEmpCorrM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getAfecEmpCorrM1()),0));
				xml.append("</afecEmpCorrM1>");
				xml.append("<noAfecEmpCorrM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getNoAfecEmpCorrM1()),0));
				xml.append("</noAfecEmpCorrM1>");
				xml.append("<afecOtrosCorrM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getAfecOtrosCorrM1()),0));
				xml.append("</afecOtrosCorrM1>");
				xml.append("<noAfecOtrosCorrM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getNoAfecOtrosCorrM1()),0));
				xml.append("</noAfecOtrosCorrM1>");
				xml.append("<numOfiCorrM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getNumOfiCorrM1()),0));
				xml.append("</numOfiCorrM1>");
			xml.append("</corrM1>");
			
			//Mediadores AF y AJ
			xml.append("<vincM1>");
				xml.append("<numEmpVincM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getNumEmpVincM1()),0));
				xml.append("</numEmpVincM1>");
				xml.append("<afecDirVincM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getAfecDirVincM1()),0));
				xml.append("</afecDirVincM1>");
				xml.append("<noAfecDirVincM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getNoAfecDirVincM1()),0));
				xml.append("</noAfecDirVincM1>");
				xml.append("<afecEmpVincM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getAfecEmpVincM1()),0));
				xml.append("</afecEmpVincM1>");
				xml.append("<noAfecEmpVincM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getNoAfecEmpVincM1()),0));
				xml.append("</noAfecEmpVincM1>");
				xml.append("<afecOtrosVincM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getAfecOtrosVincM1()),0));
				xml.append("</afecOtrosVincM1>");
				xml.append("<noAfecOtrosVincM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getNoAfecOtrosVincM1()),0));
				xml.append("</noAfecOtrosVincM1>");
				xml.append("<numOfiVincM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getNumOfiVincM1()),0));
				xml.append("</numOfiVincM1>");
			xml.append("</vincM1>");
			
			//Mediadores OV
			xml.append("<obsM1>");
				xml.append("<numEmpObsM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getNumEmpObsM1()),0));
				xml.append("</numEmpObsM1>");
				xml.append("<afecDirObsM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getAfecDirObsM1()),0));
				xml.append("</afecDirObsM1>");
				xml.append("<noAfecDirObsM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getNoAfecDirObsM1()),0));
				xml.append("</noAfecDirObsM1>");
				xml.append("<afecEmpObsM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getAfecEmpObsM1()),0));
				xml.append("</afecEmpObsM1>");
				xml.append("<noAfecEmpObsM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getNoAfecEmpObsM1()),0));
				xml.append("</noAfecEmpObsM1>");
				xml.append("<afecOtrosObsM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getAfecOtrosObsM1()),0));
				xml.append("</afecOtrosObsM1>");
				xml.append("<noAfecOtrosObsM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getNoAfecOtrosObsM1()),0));
				xml.append("</noAfecOtrosObsM1>");
				xml.append("<numOfiObsM1>");
					xml.append(P06BUtil.normalizaNumero(String.valueOf(objInformeDEC.getNumOfiObsM1()),0));
				xml.append("</numOfiObsM1>");
			xml.append("</obsM1>");

			
			
			
			//-----------------------------------  MODELO 2 --------------------------------------
			//Mediadores F, J, RF y RJ
			xml.append("<corrM2>");
				xml.append("<primInterVolTotCorrM2>");
					double primInterVolTotCorrM2 = objInformeDEC.getPrimInterVolTotNoVidaCorrM2() + objInformeDEC.getPrimInterVolTotVidaCorrM2();
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(primInterVolTotCorrM2).replaceAll("\\.",",")));
				xml.append("</primInterVolTotCorrM2>");
				xml.append("<porcVidaVolTotCorrM2>");
					double porcVidaVolTotCorrM2 = 0.0;
					if(primInterVolTotCorrM2 > 0)
						porcVidaVolTotCorrM2 = objInformeDEC.getPrimInterVolTotVidaCorrM2() * 100.0 / primInterVolTotCorrM2;
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(porcVidaVolTotCorrM2).replaceAll("\\.",",")));
				xml.append("</porcVidaVolTotCorrM2>");
				xml.append("<porcNoVidaVolTotCorrM2>");
					double porcNoVidaVolTotCorrM2 = 0.0;
					if(primInterVolTotCorrM2 > 0)
						porcNoVidaVolTotCorrM2 = objInformeDEC.getPrimInterVolTotNoVidaCorrM2() * 100.0 / primInterVolTotCorrM2;
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(porcNoVidaVolTotCorrM2).replaceAll("\\.",",")));
				xml.append("</porcNoVidaVolTotCorrM2>");
				xml.append("<redPropVolTotCorrM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(primInterVolTotCorrM2 - objInformeDEC.getAuxVolTotCorrM2() - objInformeDEC.getOtrosVolTotCorrM2()).replaceAll("\\.",",")));
				xml.append("</redPropVolTotCorrM2>");
				xml.append("<auxVolTotCorrM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getAuxVolTotCorrM2()).replaceAll("\\.",",")));
				xml.append("</auxVolTotCorrM2>");
				xml.append("<otrosVolTotCorrM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getOtrosVolTotCorrM2()).replaceAll("\\.",",")));
				xml.append("</otrosVolTotCorrM2>");
				xml.append("<coberInmedVolTotCorrM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getCoberInmedVolTotCorrM2()).replaceAll("\\.",",")));
				xml.append("</coberInmedVolTotCorrM2>");
				xml.append("<noCoberInmedVolTotCorrM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getNoCoberInmedVolTotCorrM2()).replaceAll("\\.",",")));
				xml.append("</noCoberInmedVolTotCorrM2>");
				xml.append("<comisVolTotCorrM2>");
					double comisVolTotCorrM2 = objInformeDEC.getComisVolTotNoVidaCorrM2() + objInformeDEC.getComisVolTotVidaCorrM2();
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(comisVolTotCorrM2).replaceAll("\\.",",")));
				xml.append("</comisVolTotCorrM2>");
				xml.append("<primInterNuevaCorrM2>");
					double primInterNuevaCorrM2 = objInformeDEC.getPrimInterNuevaNoVidaCorrM2() + objInformeDEC.getPrimInterNuevaVidaCorrM2();
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(primInterNuevaCorrM2).replaceAll("\\.",",")));
				xml.append("</primInterNuevaCorrM2>");
				xml.append("<porcVidaNuevaCorrM2>");
					double porcVidaNuevaCorrM2 = 0.0;
					if(primInterNuevaCorrM2 > 0)
						porcVidaNuevaCorrM2 = objInformeDEC.getPrimInterNuevaVidaCorrM2() * 100.0 / primInterNuevaCorrM2;
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(porcVidaNuevaCorrM2).replaceAll("\\.",",")));
				xml.append("</porcVidaNuevaCorrM2>");
				xml.append("<porcNoVidaNuevaCorrM2>");
					double porcNoVidaNuevaCorrM2 = 0.0;
					if(primInterNuevaCorrM2 > 0)
						porcNoVidaNuevaCorrM2 = objInformeDEC.getPrimInterNuevaNoVidaCorrM2() * 100.0 / primInterNuevaCorrM2;
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(porcNoVidaNuevaCorrM2).replaceAll("\\.",",")));
				xml.append("</porcNoVidaNuevaCorrM2>");
				xml.append("<redPropNuevaCorrM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(primInterNuevaCorrM2 - objInformeDEC.getAuxNuevaCorrM2() - objInformeDEC.getOtrosNuevaCorrM2()).replaceAll("\\.",",")));
				xml.append("</redPropNuevaCorrM2>");
				xml.append("<auxNuevaCorrM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getAuxNuevaCorrM2()).replaceAll("\\.",",")));
				xml.append("</auxNuevaCorrM2>");
				xml.append("<otrosNuevaCorrM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getOtrosNuevaCorrM2()).replaceAll("\\.",",")));
				xml.append("</otrosNuevaCorrM2>");
				xml.append("<coberInmedNuevaCorrM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getCoberInmedNuevaCorrM2()).replaceAll("\\.",",")));
				xml.append("</coberInmedNuevaCorrM2>");
				xml.append("<noCoberInmedNuevaCorrM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getNoCoberInmedNuevaCorrM2()).replaceAll("\\.",",")));
				xml.append("</noCoberInmedNuevaCorrM2>");
			xml.append("</corrM2>");
			
			//Mediadores AF y AJ
			xml.append("<vincM2>");
				xml.append("<primInterVolTotVincM2>");
					double primInterVolTotVincM2 = objInformeDEC.getPrimInterVolTotNoVidaVincM2() + objInformeDEC.getPrimInterVolTotVidaVincM2();
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(primInterVolTotVincM2).replaceAll("\\.",",")));
				xml.append("</primInterVolTotVincM2>");
				xml.append("<porcVidaVolTotVincM2>");
					double porcVidaVolTotVincM2 = 0.0;
					if(primInterVolTotVincM2 > 0)
						porcVidaVolTotVincM2 = objInformeDEC.getPrimInterVolTotVidaVincM2() * 100.0 / primInterVolTotVincM2;
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(porcVidaVolTotVincM2).replaceAll("\\.",",")));
				xml.append("</porcVidaVolTotVincM2>");
				xml.append("<porcNoVidaVolTotVincM2>");
					double porcNoVidaVolTotVincM2 = 0.0;
					if(primInterVolTotVincM2 > 0)
						porcNoVidaVolTotVincM2 = objInformeDEC.getPrimInterVolTotNoVidaVincM2() * 100.0 / primInterVolTotVincM2;
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(porcNoVidaVolTotVincM2).replaceAll("\\.",",")));
				xml.append("</porcNoVidaVolTotVincM2>");
				xml.append("<redPropVolTotVincM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(primInterVolTotVincM2 - objInformeDEC.getAuxVolTotVincM2()).replaceAll("\\.",",")));
				xml.append("</redPropVolTotVincM2>");
				xml.append("<auxVolTotVincM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getAuxVolTotVincM2()).replaceAll("\\.",",")));
				xml.append("</auxVolTotVincM2>");
				xml.append("<coberInmedVolTotVincM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getCoberInmedVolTotVincM2()).replaceAll("\\.",",")));
				xml.append("</coberInmedVolTotVincM2>");
				xml.append("<noCoberInmedVolTotVincM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getNoCoberInmedVolTotVincM2()).replaceAll("\\.",",")));
				xml.append("</noCoberInmedVolTotVincM2>");
				xml.append("<comisVolTotVincM2>");
					double comisVolTotVincM2 = objInformeDEC.getComisVolTotNoVidaVincM2() + objInformeDEC.getComisVolTotVidaVincM2();
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(comisVolTotVincM2).replaceAll("\\.",",")));
				xml.append("</comisVolTotVincM2>");
				xml.append("<primInterNuevaVincM2>");
					double primInterNuevaVincM2 = objInformeDEC.getPrimInterNuevaNoVidaVincM2() + objInformeDEC.getPrimInterNuevaVidaVincM2();
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(primInterNuevaVincM2).replaceAll("\\.",",")));
				xml.append("</primInterNuevaVincM2>");
				xml.append("<porcVidaNuevaVincM2>");
					double porcVidaNuevaVincM2 = 0.0;
					if(primInterNuevaVincM2 > 0)
						porcVidaNuevaVincM2 = objInformeDEC.getPrimInterNuevaVidaVincM2() * 100.0 / primInterNuevaVincM2;
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(porcVidaNuevaVincM2).replaceAll("\\.",",")));
				xml.append("</porcVidaNuevaVincM2>");
				xml.append("<porcNoVidaNuevaVincM2>");
					double porcNoVidaNuevaVincM2 = 0.0;
					if(primInterNuevaVincM2 > 0)
						porcNoVidaNuevaVincM2 = objInformeDEC.getPrimInterNuevaNoVidaVincM2() * 100.0 / primInterNuevaVincM2;
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(porcNoVidaNuevaVincM2).replaceAll("\\.",",")));
				xml.append("</porcNoVidaNuevaVincM2>");
				xml.append("<redPropNuevaVincM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(primInterNuevaVincM2 - objInformeDEC.getAuxNuevaVincM2()).replaceAll("\\.",",")));
				xml.append("</redPropNuevaVincM2>");
				xml.append("<auxNuevaVincM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getAuxNuevaVincM2()).replaceAll("\\.",",")));
				xml.append("</auxNuevaVincM2>");
				xml.append("<coberInmedNuevaVincM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getCoberInmedNuevaVincM2()).replaceAll("\\.",",")));
				xml.append("</coberInmedNuevaVincM2>");
				xml.append("<noCoberInmedNuevaVincM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getNoCoberInmedNuevaVincM2()).replaceAll("\\.",",")));
				xml.append("</noCoberInmedNuevaVincM2>");
			xml.append("</vincM2>");
			
			//Mediadores OV
			xml.append("<obsM2>");
				xml.append("<primInterVolTotObsM2>");
					double primInterVolTotObsM2 = objInformeDEC.getPrimInterVolTotNoVidaObsM2() + objInformeDEC.getPrimInterVolTotVidaObsM2();
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(primInterVolTotObsM2).replaceAll("\\.",",")));
				xml.append("</primInterVolTotObsM2>");
				xml.append("<porcVidaVolTotObsM2>");
					double porcVidaVolTotObsM2 = 0.0;
					if(primInterVolTotObsM2 > 0)
						porcVidaVolTotObsM2 = objInformeDEC.getPrimInterVolTotVidaObsM2() * 100.0 / primInterVolTotObsM2;
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(porcVidaVolTotObsM2).replaceAll("\\.",",")));
				xml.append("</porcVidaVolTotObsM2>");
				xml.append("<porcNoVidaVolTotObsM2>");
					double porcNoVidaVolTotObsM2 = 0.0;
					if(primInterVolTotObsM2 > 0)
						porcNoVidaVolTotObsM2 = objInformeDEC.getPrimInterVolTotNoVidaObsM2() * 100.0 / primInterVolTotObsM2;
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(porcNoVidaVolTotObsM2).replaceAll("\\.",",")));
				xml.append("</porcNoVidaVolTotObsM2>");
				xml.append("<redPropVolTotObsM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(primInterVolTotObsM2 - objInformeDEC.getAuxVolTotObsM2()).replaceAll("\\.",",")));
				xml.append("</redPropVolTotObsM2>");
				xml.append("<auxVolTotObsM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getAuxVolTotObsM2()).replaceAll("\\.",",")));
				xml.append("</auxVolTotObsM2>");
				xml.append("<coberInmedVolTotObsM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getCoberInmedVolTotObsM2()).replaceAll("\\.",",")));
				xml.append("</coberInmedVolTotObsM2>");
				xml.append("<noCoberInmedVolTotObsM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getNoCoberInmedVolTotObsM2()).replaceAll("\\.",",")));
				xml.append("</noCoberInmedVolTotObsM2>");
				xml.append("<comisVolTotObsM2>");
					double comisVolTotObsM2 = objInformeDEC.getComisVolTotNoVidaObsM2() + objInformeDEC.getComisVolTotVidaObsM2();
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(comisVolTotObsM2).replaceAll("\\.",",")));
				xml.append("</comisVolTotObsM2>");
				xml.append("<primInterNuevaObsM2>");
					double primInterNuevaObsM2 = objInformeDEC.getPrimInterNuevaNoVidaObsM2() + objInformeDEC.getPrimInterNuevaVidaObsM2();
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(primInterNuevaObsM2).replaceAll("\\.",",")));
				xml.append("</primInterNuevaObsM2>");
				xml.append("<porcVidaNuevaObsM2>");
					double porcVidaNuevaObsM2 = 0.0;
					if(primInterNuevaObsM2 > 0)
						porcVidaNuevaObsM2 = objInformeDEC.getPrimInterNuevaVidaObsM2() * 100.0 / primInterNuevaObsM2;
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(porcVidaNuevaObsM2).replaceAll("\\.",",")));
				xml.append("</porcVidaNuevaObsM2>");
				xml.append("<porcNoVidaNuevaObsM2>");
					double porcNoVidaNuevaObsM2 = 0.0;
					if(primInterNuevaObsM2 > 0)
						porcNoVidaNuevaObsM2 = objInformeDEC.getPrimInterNuevaNoVidaObsM2() * 100.0 / primInterNuevaObsM2;
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(porcNoVidaNuevaObsM2).replaceAll("\\.",",")));
				xml.append("</porcNoVidaNuevaObsM2>");
				xml.append("<redPropNuevaObsM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(primInterNuevaObsM2 - objInformeDEC.getAuxNuevaObsM2()).replaceAll("\\.",",")));
				xml.append("</redPropNuevaObsM2>");
				xml.append("<auxNuevaObsM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getAuxNuevaObsM2()).replaceAll("\\.",",")));
				xml.append("</auxNuevaObsM2>");
				xml.append("<coberInmedNuevaObsM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getCoberInmedNuevaObsM2()).replaceAll("\\.",",")));
				xml.append("</coberInmedNuevaObsM2>");
				xml.append("<noCoberInmedNuevaObsM2>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getNoCoberInmedNuevaObsM2()).replaceAll("\\.",",")));
				xml.append("</noCoberInmedNuevaObsM2>");
			xml.append("</obsM2>");
			
			
			
			
			//-----------------------------------  MODELO 3 --------------------------------------
			//Mediadores F, J, RF y RJ
			xml.append("<corrM3>");
				xml.append("<valAnadCorrM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getValAnadCorrM3()).replaceAll("\\.",",")));
				xml.append("</valAnadCorrM3>");
				xml.append("<invBrutaCorrM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getInvBrutaCorrM3()).replaceAll("\\.",",")));
				xml.append("</invBrutaCorrM3>");
				xml.append("<ingAfecCorrM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getIngAfecMod31CorrM3() + objInformeDEC.getIngAfecMod32CorrM3()).replaceAll("\\.",",")));
				xml.append("</ingAfecCorrM3>");
				xml.append("<otrosIngCorrM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getOtrosIngMod31CorrM3() + objInformeDEC.getOtrosIngMod32CorrM3()).replaceAll("\\.",",")));
				xml.append("</otrosIngCorrM3>");
				xml.append("<ingFinanCorrM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getIngFinanMod31CorrM3() + objInformeDEC.getIngFinanMod32CorrM3()).replaceAll("\\.",",")));
				xml.append("</ingFinanCorrM3>");
				xml.append("<ingRestoCorrM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getIngRestoMod31CorrM3() + objInformeDEC.getIngRestoMod32CorrM3()).replaceAll("\\.",",")));
				xml.append("</ingRestoCorrM3>");
				xml.append("<gastPerCorrM3>");
//					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getGastPerMod31CorrM3() + objInformeDEC.getGastPerMod32CorrM3()).replaceAll("\\.",",")));
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getGastPerMod32CorrM3() - objInformeDEC.getGastPerMod31CorrM3()).replaceAll("\\.",",")));
				xml.append("</gastPerCorrM3>");
				xml.append("<otrosGastCorrM3>");
//					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getOtrosGastMod31CorrM3() + objInformeDEC.getOtrosGastMod32CorrM3()).replaceAll("\\.",",")));
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getOtrosGastMod32CorrM3() - objInformeDEC.getOtrosGastMod31CorrM3()).replaceAll("\\.",",")));
				xml.append("</otrosGastCorrM3>");
				xml.append("<gastFinanCorrM3>");
//					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getGastFinanMod31CorrM3() + objInformeDEC.getGastFinanMod32CorrM3()).replaceAll("\\.",",")));
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getGastFinanMod32CorrM3() - objInformeDEC.getGastFinanMod31CorrM3()).replaceAll("\\.",",")));
				xml.append("</gastFinanCorrM3>");
				xml.append("<gastRestoCorrM3>");
//					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getGastRestoMod31CorrM3() + objInformeDEC.getGastRestoMod32CorrM3()).replaceAll("\\.",",")));
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getGastRestoMod32CorrM3() - objInformeDEC.getGastRestoMod31CorrM3()).replaceAll("\\.",",")));
				xml.append("</gastRestoCorrM3>");
			xml.append("</corrM3>");
			
			//Mediadores AF y AJ
			xml.append("<vincM3>");
				xml.append("<valAnadVincM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getValAnadVincM3()).replaceAll("\\.",",")));
				xml.append("</valAnadVincM3>");
				xml.append("<invBrutaVincM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getInvBrutaVincM3()).replaceAll("\\.",",")));
				xml.append("</invBrutaVincM3>");
				xml.append("<ingComisVincM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getIngComisVincM3()).replaceAll("\\.",",")));
				xml.append("</ingComisVincM3>");
				xml.append("<ingFinanVincM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getIngFinanVincM3()).replaceAll("\\.",",")));
				xml.append("</ingFinanVincM3>");
				xml.append("<otrosIngVincM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getOtrosIngVincM3()).replaceAll("\\.",",")));
				xml.append("</otrosIngVincM3>");
				xml.append("<ingRestoVincM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getCtaIngTotalVincM3() - objInformeDEC.getIngComisVincM3() - objInformeDEC.getIngFinanVincM3() - objInformeDEC.getOtrosIngVincM3()).replaceAll("\\.",",")));
				xml.append("</ingRestoVincM3>");
				xml.append("<costePerVincM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getCostePerVincM3()).replaceAll("\\.",",")));
				xml.append("</costePerVincM3>");
				xml.append("<gastComisVincM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getGastComisVincM3()).replaceAll("\\.",",")));
				xml.append("</gastComisVincM3>");
				xml.append("<formContVincM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getFormContVincM3()).replaceAll("\\.",",")));
				xml.append("</formContVincM3>");
				xml.append("<gastFinanVincM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getGastFinanVincM3()).replaceAll("\\.",",")));
				xml.append("</gastFinanVincM3>");
				xml.append("<otrosGastVincM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getOtrosGastVincM3()).replaceAll("\\.",",")));
				xml.append("</otrosGastVincM3>");
				xml.append("<gastRestoVincM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getCtaGastTotalVincM3() - objInformeDEC.getCostePerVincM3() - objInformeDEC.getGastComisVincM3() - objInformeDEC.getFormContVincM3() - objInformeDEC.getGastFinanVincM3() - objInformeDEC.getOtrosGastVincM3()).replaceAll("\\.",",")));
				xml.append("</gastRestoVincM3>");
			xml.append("</vincM3>");
			
			//Mediadores OV
			xml.append("<obsM3>");
				xml.append("<valAnadObsM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getValAnadObsM3()).replaceAll("\\.",",")));
				xml.append("</valAnadObsM3>");
				xml.append("<invBrutaObsM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getInvBrutaObsM3()).replaceAll("\\.",",")));
				xml.append("</invBrutaObsM3>");
				xml.append("<ingComisObsM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getIngComisObsM3()).replaceAll("\\.",",")));
				xml.append("</ingComisObsM3>");
				xml.append("<ingFinanObsM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getIngFinanObsM3()).replaceAll("\\.",",")));
				xml.append("</ingFinanObsM3>");
				xml.append("<otrosIngObsM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getOtrosIngObsM3()).replaceAll("\\.",",")));
				xml.append("</otrosIngObsM3>");
				xml.append("<ingRestoObsM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getCtaIngTotalObsM3() - objInformeDEC.getIngComisObsM3() - objInformeDEC.getIngFinanObsM3() - objInformeDEC.getOtrosIngObsM3()).replaceAll("\\.",",")));
				xml.append("</ingRestoObsM3>");
				xml.append("<costePerObsM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getCostePerObsM3()).replaceAll("\\.",",")));
				xml.append("</costePerObsM3>");
				xml.append("<gastComisObsM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getGastComisObsM3()).replaceAll("\\.",",")));
				xml.append("</gastComisObsM3>");
				xml.append("<formContObsM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getFormContObsM3()).replaceAll("\\.",",")));
				xml.append("</formContObsM3>");
				xml.append("<gastFinanObsM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getGastFinanObsM3()).replaceAll("\\.",",")));
				xml.append("</gastFinanObsM3>");
				xml.append("<otrosGastObsM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getOtrosGastObsM3()).replaceAll("\\.",",")));
				xml.append("</otrosGastObsM3>");
				xml.append("<gastRestoObsM3>");
					xml.append(P06BUtil.normalizaNumConDecimales(decimalFormat.format(objInformeDEC.getCtaGastTotalObsM3() - objInformeDEC.getCostePerObsM3() - objInformeDEC.getGastComisObsM3() - objInformeDEC.getFormContObsM3() - objInformeDEC.getGastFinanObsM3() - objInformeDEC.getOtrosGastObsM3()).replaceAll("\\.",",")));
				xml.append("</gastRestoObsM3>");
			xml.append("</obsM3>");
		xml.append("</informeDEC>");
		
						
		String xmlString = xml.toString();
		
		//En la razon social de algunos mediadores est el smbolo &. Da el error:
		//"The entity name must immediately follow the '&' in the entity reference."
		//Sustituyendo el smbolo & por su codificacin, desaparece el error.
		//Para este informe, NO se va a dar este caso, pero lo dejo.
		xmlString = xmlString.replaceAll("&","&amp;");
		P06BLog.send(2,"P06BInformeResumenDECXML", "getXml(...): Fin");
		return xmlString;
	}
	
}